<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class DoorPanelResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $attrs = $this->resource->getAttributes();
        unset($attrs['created_at'], $attrs['updated_at'], $attrs['deleted_at']);

        // Add a ready-to-use URL for the frontend
        $imagePath = $attrs['image_path'] ?? null;
        $attrs['image_url'] = $imagePath ? Storage::disk('public')->url($imagePath) : null;

        return [
            'id' => $this->id,
            'attributes' => $attrs,
        ];
    }
}
