<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('offers', function (Blueprint $table) {
            if (!Schema::hasColumn('offers', 'name')) $table->string('name')->nullable();
            if (!Schema::hasColumn('offers', 'description')) $table->text('description')->nullable();
            if (!Schema::hasColumn('offers', 'margin')) $table->decimal('margin', 6, 2)->default(0);
            if (!Schema::hasColumn('offers', 'color')) $table->string('color', 80)->nullable();

            if (!Schema::hasColumn('offers', 'profile_id')) $table->unsignedBigInteger('profile_id')->nullable()->index();
            if (!Schema::hasColumn('offers', 'iron_id')) $table->unsignedBigInteger('iron_id')->nullable()->index();
        });

        Schema::table('offers', function (Blueprint $table) {
            try {
                $table->foreign('profile_id')->references('id')->on('profiles')->nullOnDelete();
            } catch (\Throwable $e) {}
            try {
                $table->foreign('iron_id')->references('id')->on('irons')->nullOnDelete();
            } catch (\Throwable $e) {}
        });
    }

    public function down(): void {}
};
