<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('door_panels')) {
            Schema::create('door_panels', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                // stored as "door-panels/<filename>.png" in the public disk
                $table->string('image_path')->nullable();
                // EXTRA cost (panel itself)
                $table->decimal('price', 12, 2)->default(0);
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('door_panels');
    }
};
