import axios from "axios";

const token = document
  .querySelector('meta[name="csrf-token"]')
  ?.getAttribute("content");

const api = axios.create({
  baseURL: "/api",
  withCredentials: true,
  headers: {
    "X-Requested-With": "XMLHttpRequest",
    ...(token ? { "X-CSRF-TOKEN": token } : {}),
  },
});

export default api;
