import React from "react";
import { UI } from "../../constants/pvc";

export function Pill({ children, tone = "soft" }) {
  const map = {
    soft: { bg: "#f1f5f9", bd: UI.border, fg: UI.ink },
    blue: { bg: "#dbeafe", bd: "#bfdbfe", fg: "#1e3a8a" },
    green: { bg: "#dcfce7", bd: "#bbf7d0", fg: "#14532d" },
    orange: { bg: "#ffedd5", bd: "#fed7aa", fg: "#7c2d12" },
  };
  const t = map[tone] || map.soft;

  return (
    <span
      style={{
        display: "inline-flex",
        alignItems: "center",
        gap: 6,
        padding: "4px 10px",
        borderRadius: 999,
        background: t.bg,
        border: `1px solid ${t.bd}`,
        color: t.fg,
        fontSize: 12,
        fontWeight: 650,
        whiteSpace: "nowrap",
      }}
    >
      {children}
    </span>
  );
}

export function Btn({ children, onClick, variant = "ghost", disabled, style, title }) {
  const base = {
    borderRadius: 12,
    padding: "10px 12px",
    fontSize: 13,
    fontWeight: 700,
    cursor: disabled ? "not-allowed" : "pointer",
    opacity: disabled ? 0.6 : 1,
    border: `1px solid ${UI.border}`,
    background: "#fff",
    color: UI.ink,
  };
  const variants = {
    ghost: { background: "#fff", border: `1px solid ${UI.border}`, color: UI.ink },
    primary: { background: UI.primary, border: `1px solid ${UI.primary}`, color: "#fff" },
    soft: { background: "#f1f5f9", border: `1px solid ${UI.border}`, color: UI.ink },
    danger: { background: "#fee2e2", border: "1px solid #fecaca", color: "#b91c1c" },
    success: { background: UI.green, border: `1px solid ${UI.green}`, color: "#fff" },
  };
  return (
    <button
      title={title}
      disabled={disabled}
      onClick={disabled ? undefined : onClick}
      style={{ ...base, ...(variants[variant] || variants.ghost), ...style }}
    >
      {children}
    </button>
  );
}

export function Field({ label, hint, children }) {
  return (
    <div style={{ display: "flex", flexDirection: "column", gap: 6 }}>
      <div style={{ display: "flex", alignItems: "baseline", justifyContent: "space-between", gap: 10 }}>
        <div style={{ fontSize: 12, fontWeight: 700, color: UI.ink }}>{label}</div>
        {hint ? <div style={{ fontSize: 11, color: UI.muted }}>{hint}</div> : null}
      </div>
      {children}
    </div>
  );
}

export function TextInput(props) {
  return (
    <input
      {...props}
      style={{
        width: "100%",
        border: `1px solid ${UI.border}`,
        borderRadius: 12,
        padding: "10px 12px",
        fontSize: 13,
        outline: "none",
        ...props.style,
      }}
    />
  );
}

export function Select(props) {
  return (
    <select
      {...props}
      style={{
        width: "100%",
        border: `1px solid ${UI.border}`,
        borderRadius: 12,
        padding: "10px 12px",
        fontSize: 13,
        outline: "none",
        background: "#fff",
        ...props.style,
      }}
    />
  );
}
