import React from "react";
import { UI } from "../../constants/ui";

export function Btn({ children, onClick, variant = "ghost", disabled, style, title }) {
  const base = {
    borderRadius: 12,
    padding: "10px 12px",
    fontSize: 13,
    fontWeight: 700,
    cursor: disabled ? "not-allowed" : "pointer",
    opacity: disabled ? 0.6 : 1,
    border: `1px solid ${UI.border}`,
    background: "#fff",
    color: UI.ink,
  };

  const variants = {
    ghost: { background: "#fff", border: `1px solid ${UI.border}`, color: UI.ink },
    primary: { background: UI.primary, border: `1px solid ${UI.primary}`, color: "#fff" },
    soft: { background: "#f1f5f9", border: `1px solid ${UI.border}`, color: UI.ink },
    danger: { background: "#fee2e2", border: "1px solid #fecaca", color: "#b91c1c" },
    success: { background: UI.green, border: `1px solid ${UI.green}`, color: "#fff" },
  };

  return (
    <button
      title={title}
      disabled={disabled}
      onClick={disabled ? undefined : onClick}
      style={{ ...base, ...(variants[variant] || variants.ghost), ...style }}
    >
      {children}
    </button>
  );
}
