import React from "react";
import { UI } from "../../constants/ui";

export function Field({ label, hint, children }) {
  return (
    <div style={{ display: "flex", flexDirection: "column", gap: 6 }}>
      <div style={{ display: "flex", alignItems: "baseline", justifyContent: "space-between", gap: 10 }}>
        <div style={{ fontSize: 12, fontWeight: 700, color: UI.ink }}>{label}</div>
        {hint ? <div style={{ fontSize: 11, color: UI.muted }}>{hint}</div> : null}
      </div>
      {children}
    </div>
  );
}
