import React from "react";
import { UI } from "../../constants/ui";

export function Modal({ open, title, onClose, children, footer }) {
  if (!open) return null;

  return (
    <div
      style={{
        position: "fixed",
        inset: 0,
        background: "rgba(15,23,42,.45)",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        zIndex: 9999,
        padding: 14,
      }}
      onMouseDown={(e) => {
        if (e.target === e.currentTarget) onClose?.();
      }}
    >
      <div
        style={{
          background: "#fff",
          width: "min(680px, 95vw)",
          borderRadius: 14,
          boxShadow: UI.shadow2,
          border: `1px solid ${UI.border}`,
          overflow: "hidden",
        }}
      >
        <div style={{ padding: "14px 16px", borderBottom: `1px solid ${UI.border}` }}>
          <div style={{ display: "flex", alignItems: "center", justifyContent: "space-between", gap: 10 }}>
            <h3 style={{ margin: 0, fontSize: 14, fontWeight: 750, color: UI.ink }}>{title}</h3>
            <button
              onClick={onClose}
              style={{
                border: `1px solid ${UI.border}`,
                background: "#fff",
                borderRadius: 10,
                padding: "6px 10px",
                cursor: "pointer",
                fontSize: 12,
              }}
            >
              ✕
            </button>
          </div>
        </div>

        <div style={{ padding: 16 }}>{children}</div>

        <div style={{ padding: 12, borderTop: `1px solid ${UI.border}` }}>
          {footer ? (
            footer
          ) : (
            <div style={{ textAlign: "right" }}>
              <button
                onClick={onClose}
                style={{
                  background: "transparent",
                  border: `1px solid ${UI.border}`,
                  borderRadius: 10,
                  padding: "8px 12px",
                  fontSize: 12,
                  cursor: "pointer",
                }}
              >
                Mbyll
              </button>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}
