// src/components/editor/Canvas.jsx
import React, { useMemo } from "react";
import { Btn } from "../../components/common/UI";
import { UI } from "../../constants/pvc";
import SvgPreview from "./SvgPreview";
import { svgForPosition } from "./CuttingList";
import { printSvgDocument } from "./PrintService";

export default function Canvas({ draft, offer, materials }) {
  const svgString = useMemo(() => {
    if (!draft) return "";
    return svgForPosition(draft, offer, materials, { showDims: true });
  }, [draft, offer, materials]);

  return (
    <div
      className="canvasCard"
      style={{
        border: `1px solid ${UI.border}`,
        borderRadius: 18,
        background: "#fff",
        boxShadow: UI.shadow,
        padding: 14,
        minWidth: 0,
      }}
    >
      <div style={{ display: "flex", justifyContent: "space-between", gap: 10, alignItems: "center", marginBottom: 10 }}>
        <div style={{ fontWeight: 950 }}>Skica (SVG Preview)</div>

        <Btn
          variant="soft"
          onClick={() => {
            if (!draft) return;
            const s = svgForPosition(draft, offer, materials, { showDims: true });
            printSvgDocument({ title: `${offer.name} — ${draft.name}`, svgStrings: [s] });
          }}
          disabled={!draft}
        >
          🖨️ Print këtë
        </Btn>
      </div>

      <SvgPreview svgString={svgString} />
    </div>
  );
}
