// src/components/editor/CuttingList.js

import { FRAME_WELD_ADD_MM, SASH_REDUCE_MM, BEAD_REDUCE_MM, IRON_REDUCE_MM } from "../../constants/pvc";

export const buildCuttingRows = (pos, materials, fallbackGlassName = "") => {
  const rows = [];
  let nr = 1;

  const frameVert = pos.frameH + FRAME_WELD_ADD_MM;
  const frameHor = pos.frameW + FRAME_WELD_ADD_MM;

  rows.push({ nr: nr++, code: "88171.BB [Strukturë]", length: frameVert, cut: "\\=/", pcs: 2, arm: "V309", armLen: frameVert - IRON_REDUCE_MM });
  rows.push({ nr: nr++, code: "88171.BB [Strukturë]", length: frameHor, cut: "\\=/", pcs: 2, arm: "V303", armLen: frameHor - IRON_REDUCE_MM });

  if (pos.hasRoll) rows.push({ nr: nr++, code: "ROLLBOX.BB [Roletë]", length: Math.round(pos.frameW), cut: "\\=/", pcs: 1, arm: "", armLen: 0 });

  if (pos.extraBottomProfile && pos.extraBottomProfile > 0) {
    rows.push({
      nr: nr++,
      code: pos.isDoor ? "THRESHOLD.BB [Prag dere]" : "BASE.BB [Profil poshtë]",
      length: Math.round(pos.frameW),
      cut: "\\=/",
      pcs: 1,
      arm: "",
      armLen: 0,
    });
  }

  if (pos.shapeType === "sloped") {
    rows.push({ nr: nr++, code: `IRREG SIPËR [majtas ${pos.topLeftOffsetMm || 0} / djathtas ${pos.topRightOffsetMm || 0} mm]`, length: "", cut: "", pcs: "", arm: "", armLen: 0 });
  }

  (pos.tProfiles || []).forEach((t) => {
    const len = t.orientation === "horizontal" ? pos.frameW + FRAME_WELD_ADD_MM : pos.frameH + FRAME_WELD_ADD_MM;
    rows.push({ nr: nr++, code: t.orientation === "horizontal" ? "T.BB [Horizontale]" : "T.BB [Vertikale]", length: len, cut: "\\=/", pcs: 1, arm: "", armLen: 0 });
  });

  if (pos.sashes && pos.sashes.length) {
    const sashCount = pos.sashes.length;
    const sashW = (pos.frameW - SASH_REDUCE_MM) / sashCount;
    const sashH = pos.frameH - SASH_REDUCE_MM;

    rows.push({ nr: nr++, code: "88270.BB [Profil Z]", length: Math.round(sashH), cut: "\\=/", pcs: 2 * sashCount, arm: "V303", armLen: Math.round(sashH - IRON_REDUCE_MM) });
    rows.push({ nr: nr++, code: "88270.BB [Profil Z]", length: Math.round(sashW), cut: "\\=/", pcs: 2 * sashCount, arm: "V303", armLen: Math.round(sashW - IRON_REDUCE_MM) });

    rows.push({ nr: nr++, code: "2451.BB [Llajsne]", length: Math.round(sashH - (BEAD_REDUCE_MM - 40)), cut: "/__/", pcs: 2 * sashCount, arm: "", armLen: 0 });
    rows.push({ nr: nr++, code: "2451.BB [Llajsne]", length: Math.round(sashW - (BEAD_REDUCE_MM - 40)), cut: "/__/", pcs: 2 * sashCount, arm: "", armLen: 0 });

    const hasAnyGlass = (pos.sashes || []).some((s) => s.hasGlass) || (pos.segmentsGlass && Object.keys(pos.segmentsGlass).length > 0);

    if (hasAnyGlass) {
      const glassW = Math.round(sashW - 8);
      const glassH = Math.round(sashH - 8);
      const glassCode = materials?.glassTypes?.find((g) => g.id === pos.glassTypeId)?.name || fallbackGlassName || "";
      rows.push({ nr: "X", code: glassCode, length: `${glassW}×${glassH}`, cut: "", pcs: sashCount, arm: "", armLen: 0 });
    }
  }

  return rows;
};
