// src/components/editor/PrintService.js

export const openPrintWindow = (title, bodyHtml) => {
  const w = window.open("", "_blank");
  if (!w) return;

  w.document.write(`
    <html>
      <head>
        <title>${title}</title>
        <style>
          body{font-family:Arial,Helvetica,sans-serif;font-size:12px;margin:18px;color:#111;}
          h1,h2,h3,h4{margin:0 0 6px 0;}
          .small{font-size:10px;color:#555;}
          .muted{color:#555;}
          .page{page-break-after:always;margin-bottom:24px;}
          .headerRow{display:flex;justify-content:space-between;align-items:flex-start;gap:16px;}
          .thumbBox{flex:0 0 260px;max-width:260px;}
          .thumbBox svg{max-width:100%;height:auto;}
          .mainBox{flex:1;min-width:0;}
          .sketchBig{width:100%;display:flex;justify-content:center;}
          .sketchBig svg{width:92%;height:auto;}
          table{width:100%;border-collapse:collapse;margin-top:10px;}
          th,td{border:1px solid #666;padding:4px 6px;font-size:11px;vertical-align:top;}
          th{text-align:left;background:#f1f5f9;}
          .totals{margin-top:10px;font-size:12px;}
          @media print{
            body{margin:12mm;}
            .page{page-break-after:always;}
          }
        </style>
      </head>
      <body>${bodyHtml}</body>
    </html>
  `);
  w.document.close();
  w.focus();
  w.print();
};

export const buildPositionsForPrint = (offer, buildCurrentPositionObject) => {
  const list = [...(offer.positions || [])];
  const current = buildCurrentPositionObject?.();
  if (current) list.push(current);
  return list;
};
