import React from "react";
import { createBrowserRouter } from "react-router-dom";
import { PATHS } from "./paths";
import { RequireAuth, RequireRole } from "./guards";

import LoginPage from "../pages/LoginPage";
import DashboardPage from "../pages/DashboardPage";
import MaterialsPage from "../pages/MaterialsPage";
import SuperAdminPage from "../pages/SuperAdminPage";

export const router = createBrowserRouter([
  // public
  { path: PATHS.login, element: <LoginPage /> },

  // protected
  {
    element: <RequireAuth />,
    children: [
      { path: PATHS.dashboard, element: <DashboardPage /> },
      { path: PATHS.materials, element: <MaterialsPage /> },

      // role protected
      {
        element: <RequireRole role="super_admin" />,
        children: [{ path: PATHS.superAdmin, element: <SuperAdminPage /> }],
      },
    ],
  },
]);
