export function migrateOffers(existingOffers, materials) {
  const profileByName = new Map(materials.profiles.map((p) => [p.name, p.id]));
  const ironByName = new Map(materials.irons.map((i) => [i.name, i.id]));
  const defaultProfileId = materials.profiles[0]?.id || "profile-1";
  const defaultIronId = materials.irons[0]?.id || "iron-1";

  return (existingOffers || []).map((o) => {
    const profileId =
      o.profileId ||
      profileByName.get(o.profileName) ||
      profileByName.get(o.profile) ||
      defaultProfileId;

    const ironId =
      o.ironId ||
      ironByName.get(o.ironName) ||
      ironByName.get(o.iron) ||
      defaultIronId;

    return {
      ...o,
      profileId,
      ironId,
      updatedAt: o.updatedAt || Date.now(),
      createdAt: o.createdAt || Date.now(),
      positions: Array.isArray(o.positions) ? o.positions : [],
    };
  });
}
