<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\OfferController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\IronController;
use App\Http\Controllers\Api\GlassTypeController;
use App\Http\Controllers\Api\AccessoryController;
use App\Http\Controllers\Api\PositionController;
use App\Http\Controllers\Api\DoorPanelController;

Route::apiResource('offers', OfferController::class);
Route::apiResource('profiles', ProfileController::class);
Route::apiResource('irons', IronController::class);
Route::apiResource('glass-types', GlassTypeController::class);
Route::apiResource('accessories', AccessoryController::class);
Route::apiResource('door-panels', DoorPanelController::class);

// Positions API (already correct)
Route::prefix('offers/{offer}')->group(function () {
    Route::get('/positions', [PositionController::class, 'index']);
    Route::post('/positions', [PositionController::class, 'store']);
    Route::post('/positions/sync', [PositionController::class, 'sync']);
});

Route::get('/positions/{position}', [PositionController::class, 'show']);
Route::match(['put','patch'], '/positions/{position}', [PositionController::class, 'update']);
Route::delete('/positions/{position}', [PositionController::class, 'destroy']);


Route::post('/offers/{offer}/positions/sync', [PositionController::class, 'sync']);
