<?php

use Illuminate\Support\Facades\Route;
use Stancl\Tenancy\Middleware\InitializeTenancyByDomain;
use Stancl\Tenancy\Middleware\PreventAccessFromCentralDomains;

Route::middleware([
    'web',
    InitializeTenancyByDomain::class,
    PreventAccessFromCentralDomains::class,
])->group(function () {

    // Tenant auth routes (login on tenant domain)
    require __DIR__.'/auth.php';

    // After login, send them to React app
    Route::get('/dashboard', fn () => redirect('/app'))
        ->middleware('auth')
        ->name('dashboard');

    // React PVC app entry
    Route::get('/app/{any?}', fn () => view('spa'))
        ->where('any', '.*')
        ->middleware('auth')
        ->name('tenant.app');
});
