import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import react from "@vitejs/plugin-react";

export default defineConfig({
  build: {
    outDir: "../public/app",   // adjust path if your vite folder is different
    emptyOutDir: true,
  },
  base: "/app/",  

  plugins: [
    laravel({
      input: ["resources/js/winetro/main.jsx"],
      refresh: true,
    }),
    react(),
  ],

  server: {
    host: "127.0.0.1",     // important on Windows (avoid ::1)
    strictPort: true,
    port: 5173,


    proxy: {
      "/api": {
        target: "http://localhost:8000",
        changeOrigin: true,
        secure: false,
      }
    }
  },
});
